"use strict";
const config = require("config");
const $ = require("../gulp/config");
const m = require("../src/js/api");

const AVCodes = require("./AVCodes");
const schema = require("./schemas/credentials");

const url = m.getURL("Authenticate");
const TestName = "Test Authentication process";

let subTestName = "";
let credentials = "";

describe(TestName, function(){
	it("Passing invalid Access/Verify Code pair should get a \"Not a valid ACCESS CODE/VERIFY CODE pair.\" message from the server", function(done){
		let request = $.request("");
		request.post(url)
		.set("Content-Type", "application/x-www-form-urlencoded")
		.send(AVCodes.BAD_AVCodes)
		.end(function(err, res){
			$.expect(err).to.equal(null, "We received an error -", JSON.stringify(err));
			$.expect(res.body.error).to.be.equal("Not a valid ACCESS CODE/VERIFY CODE pair.", "AVPair check failed")
			$.expect(res.statusCode).to.equal(401, `Received an unexpected StatusCode (${res.statusCode}) from the server`);
			done();
		});
	});

	it("Passing invalid stationID should get a \"The facility connection information is incorrect or missing.\" message from the server", function(done){
		let request = $.request("");
		request.post(url)
		.set("Content-Type", "application/x-www-form-urlencoded")
		.send(AVCodes.BAD_StationID)
		.end(function(err, res){
			$.expect(err).to.equal(null, "We received an error -", JSON.stringify(err));
			$.expect(res.body.error).to.be.equal("ERROR: The facility connection information is incorrect or missing.", "StationID check failed")
			$.expect(res.statusCode).to.equal(401, `Received an unexpected StatusCode (${res.statusCode}) from the server`);
			done();
		});
	});

	it("Passing valid credentials should get a valid JWT from the server from the server", function(done){
		let request = $.request("");
		request.post(url)
		.set("Content-Type", "application/x-www-form-urlencoded")
		.send(AVCodes.GOOD_AVCodes)
		.end(function(err, res){
			$.expect(err).to.equal(null, "We received an error -", JSON.stringify(err));
			$.expect(res.statusCode).to.equal(200, `Received an unexpected StatusCode (${res.statusCode}) from the server`);
			$.expect(res.body.success).to.equal(true, "Test Failed");
			$.expect(res.body.message, "Invalid Message - ").to.equal("Enjoy your token!");
			credentials = res.body;
			done();
		});
	});

	it("Credential Information received should match data schema", function(done) {
		$.expect(credentials).to.be.jsonSchema(schema);
		done();
	});
});
